<?php

function fetchData($url) {
    $json = file_get_contents($url);
    return json_decode($json, true);
}

function formatTimestamp($isoDate) {
    $timestamp = strtotime($isoDate);
    return $timestamp ? date("U -- d.m.Y H:i:s" , $timestamp) : "-";
}

function getGpsCoord($value) {
    return $value / 10000000;
}

function calculateDistance($lat1, $lon1, $lat2, $lon2) {
    if ($lat1 == 0 && $lon1 == 0) return null;
    $earthRadius = 6371;
    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);
    $a = sin($dLat / 2) * sin($dLat / 2) +
         cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
         sin($dLon / 2) * sin($dLon / 2);
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
    return round($earthRadius * $c, 2);
}

$url = "http://10.0.0.XXX:8080/provoz.json";
$data = fetchData($url);
$nodes = [];

$fixedLat = 50.XXX;
$fixedLon = 15.XXX;

foreach ($data as $id => $node) {
    if (!isset($node['nodeinfo']['id'])) continue;
    
    $latitude = isset($node['position']['latitude']) ? getGpsCoord($node['position']['latitude']) : 0;
    $longitude = isset($node['position']['longitude']) ? getGpsCoord($node['position']['longitude']) : 0;

    $distance = calculateDistance($latitude, $longitude, $fixedLat, $fixedLon);
    
    $location = ($latitude == 0 && $longitude == 0) ? "-" : "<a href='https://www.openstreetmap.org/?mlat={$latitude}&mlon={$longitude}' target='_blank'>{$latitude}, {$longitude}</a>";
    
    $nodes[] = [
        'last_seen' => strtotime($node['last_seen']),
        'last_seen_formatted' => formatTimestamp($node['last_seen']),
        'number_packets' => $node['number_packets'] ?? '-',
        'longname' => $node['nodeinfo']['longname'] ?? '-',
        'shortname' => $node['nodeinfo']['shortname'] ?? '-',
        'id' => $node['nodeinfo']['id'] ?? 'xxxxxx',
        'hop_start' => $node['hop_start'] ?? 0,
        'hops_away' => $node['hops_away'] ?? 0,
	'altitude' => isset($node['position']['altitude']) ? $node['position']['altitude'] : '-',

        'location' => $location,
        'distance' => $distance !== null ? $distance . ' km' : '-',
        'battery_level' => $node['telemetry']['battery_level'] ?? '-',
        'voltage' => $node['telemetry']['voltage'] ?? '-100',
        'temperature' => $node['telemetry']['temperature'] ?? '-273'
    ];
}

echo "<!DOCTYPE html>
<html>
<head>
    <meta charset='UTF-8'>
    <title>Meshtastic data z MQTT serveru</title>
    <style>
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid black; padding: 8px; text-align: left; }
        th { cursor: pointer; background-color: #f2f2f2; }
    </style>
    <script>
        function sortTable(columnIndex) {
            let table = document.getElementById('dataTable');
            let rows = Array.from(table.rows).slice(1);
            let order = table.dataset.sortOrder === 'asc' ? 'desc' : 'asc';
            
            rows.sort((a, b) => {
                let cellA = a.cells[columnIndex].innerText.trim().toLowerCase();
                let cellB = b.cells[columnIndex].innerText.trim().toLowerCase();
                
                return order === 'asc' ? cellA.localeCompare(cellB, 'cs', { numeric: true, sensitivity: 'base' }) 
                                       : cellB.localeCompare(cellA, 'cs', { numeric: true, sensitivity: 'base' });
            });
            
            table.tBodies[0].append(...rows);
            table.dataset.sortOrder = order;
        }
    </script>
</head>
<body>
    <table id='dataTable' data-sort-order='asc'>
        <tr>";

$headers = ['Poslední data', 'Jméno dlouze', 'krátce', '∑' , 'Hopů', 'MAC', 'm.n.m.', 'GPS', 'km z K.', 'Baterie', 'Napětí', 'Teplota'];
foreach ($headers as $index => $label) {
    echo "<th onclick='sortTable({$index})'>{$label} &#9650;&#9660;</th>";
}

echo "</tr>";
foreach ($nodes as $node) {
    echo "<tr>
        <td>{$node['last_seen_formatted']}</td>
        <td>{$node['longname']}</td>
        <td>{$node['shortname']}</td>
        <td>{$node['number_packets']}</td>
        <td>" . $node['hops_away'] . " (" . $node['hop_start'] . ")</td>
        <td>{$node['id']}</td>
        <td>{$node['altitude']}</td>
        <td>{$node['location']}</td>
        <td>{$node['distance']}</td>
        <td>{$node['battery_level']}%</td>
        <td>" . round($node['voltage'], 2) . " V</td>
        <td>" . round($node['temperature'], 2) . " °C</td>
    </tr>";
}

echo "</table>
</body>
</html>";

?>
